% alternatives_estimation_mode.m
% 
% estimates different models
% 
% Estimating Macroeconomic Models of Financial Crises: An Endogenous Regime-Switching Approach*
%   Gianluca Benigno, Andrew Foerster, Christopher Otrok, Alessandro Rebucci
% 
% Updated July 2024
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %


% -- Clear Workspace -- %
clc;
clear;
close all;

% -- Model Selection -- %
model_selection = 4; 
    % 1 is Nonbinding model
    % 2 is Nonbinding SV model
    % 3 is Exogenous model
    % 4 is Exogenous SV model
    % 5 is Endogenous Model

% -- Path Management -- %
if model_selection == 1
    addpath('Model_Nonbinding');      
    addpath('../Solver');
    svmodel = 0;
elseif model_selection == 2
    addpath('Model_Nonbinding_SV'); 
    addpath('../Solver - SV');
    svmodel = 1;
elseif model_selection == 3
    addpath('Model_Exogenous'); 
    addpath('../Solver');
    svmodel = 0;
elseif model_selection == 4
    addpath('Model_Exogenous_SV'); 
    addpath('../Solver - SV');
    svmodel = 1;
elseif model_selection == 5
    addpath('Model_Endogenous');
    addpath('../Solver');
    svmodel = 0;
end

% -- Options -- %
addpath('../Data');                 % add path with data
addpath(genpath('../Utilities'));   % add path with utilities
GLOBALS = globals();                % load structure of GLOBALS

% -- Filtering Type -- %
kf_filtering_level = 0;

% -- Set System Dimensions -- %
ny = GLOBALS.ny;   % # of control variables
nx = GLOBALS.nx;   % # of state variables
ne = GLOBALS.ne;   % # of structural shocks
ns = GLOBALS.ns;   % # of regimes

% -- Set Estimation Dimensions -- %
NX = GLOBALS.estimation.NX;   % # of states in estimation

% -- Set Observables in Estimation -- %
y = GLOBALS.y;
  
% -- Parameter Transform -- %
THETA   = getparams(GLOBALS);
THETA   = param_transform(THETA,GLOBALS,1);
   
% -- Check of Inital Condition -- %
if svmodel == 0
    endo_ms_lik_2nd_kim_nelson_transform(THETA,y,kf_filtering_level,1,1,GLOBALS)
elseif svmodel == 1
    endo_ms_lik_2nd_kim_nelson_transform_SV(THETA,y,kf_filtering_level,1,1,GLOBALS)
end

% -- Minimizer -- %
crit = 0.1;             % 1e-8
nit  = 10;              % 1e5
if svmodel == 0
    [MinFuncValue,post_mode] =...
        csminwel('endo_ms_lik_2nd_kim_nelson_transform',THETA,...
        eye(length(THETA)),[],crit,nit,...
        y,kf_filtering_level,1,1,GLOBALS);
elseif svmodel == 1
    [MinFuncValue,post_mode] =...
        csminwel('endo_ms_lik_2nd_kim_nelson_transform_SV',THETA,...
        eye(length(THETA)),[],crit,nit,...
        y,kf_filtering_level,1,1,GLOBALS);
end


% -- Print Output -- %
disp(['Function Value = ' num2str(MinFuncValue)]);
disp(' ');
disp('Mode = ');
disp(post_mode);